<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par un script de configuration, qui s'appellera par exemple machin.php et qui sera la page web demandée. La version par défaut et à modifier s'appelle photos-exemple.php
if ( !defined('OK') )  exit();

///////////////////////////////
// Initialisation, récupération et vérification de la demande
$adresse = htmlentities("http://" . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF']);
$script = htmlentities($_SERVER['PHP_SELF']);
include('photos-init.php');

///////////////////////////////
// Si $img_id et $_GET["taille"] sont définis, on demande une photo
if ( isset($_REQUEST["taille"]) && $img_id )  {
  // getimagesize fournit un tableau contenant les dimensions et le type mime de l'image
  $info = getimagesize($img);
  $taille = $_REQUEST["taille"];
  switch ($taille)  {
  // Si $taille vaut 0, on veut la photo ou le film en taille originale; 1 ou 2, c'est une miniature
  case 0:
    header("Content-type: ${info['mime']}");
    header("Content-Disposition: attachment; filename=\"$img\"");
    readfile($img);
    exit;
  case 1:
  case 2:
    $dim = $dimensions[$taille-1];
    break;
  default:
    // Si $taille n'est pas bon, redirection en enlevant le paramètre
    header("Location: $adresse?rep=$rep_id&img=$img_id");
    exit;
  }
  // Si on veut une miniature d'image (et non de film)
  if ( stristr($info['mime'],"image") )  {
    header("Content-type: image/jpeg");
    header("Content-Disposition: inline; filename=\"$img\"");
    // Si la miniature n'est pas disponible dans le cache, on la génère
    $imagecache = "$cache$rep_id-$img_id-$dim." . substr($img,0,strrpos($img,".")) . ".jpg";
    if ( !file_exists($imagecache) )  include('photos-miniatures.php');
  }
  // Si on veut une icône de film
  else  {
    header("Content-type: image/png");
    header("Content-Disposition: inline; filename=\"video.png\"");
    // Si l'icône n'est pas disponible dans le cache, on la génère
    $imagecache = ($taille == 1) ? "$cache$rep_id-$img_id." . substr($img,0,strrpos($img,".")) . ".png" : "{$cache}video-$dim.png";
    if ( !file_exists($imagecache) )  include('photos-films.php');
  }
  readfile($imagecache);
  exit;
}

///////////////////////////////
// icone est le paramètre qui défini "on veut générer l'icône d'un répertoire"
if ( isset($_REQUEST["icone"]) )  {
  $imagecache = "$cache$rep_id.$nouvrep.png";
  // Si l'icône n'est pas disponible dans le cache, on la génère
  if ( !file_exists($imagecache) )  include('photos-repertoires.php');
  // Affichage de l'icône
  header("Content-type: image/png");
  header("Content-Disposition: inline; filename=\"$nouvrep.png\"");
  readfile($imagecache);
  exit;
}

///////////////////////////////
// Page d'administration
if ( isset($_REQUEST['admin']) )  {
  include('photos-session.php');
  if ( is_null($_SESSION['OK']) )  include('photos-login.php');
  elseif ( isset($_REQUEST['cache']) )  {
    if ( isset($_REQUEST['liste']) )  include('photos-liste-cache.php');
    else  include('photos-cache.php');
  }
  // Visualisation des icônes, pour voir si les couleurs vont bien
  elseif ( isset($_REQUEST['image']) )  {
    // On demande un exemple d'icône de répertoire
    if ( $_REQUEST['image'] == 1 )  {
      // Renommage temporaire
      $imagerep1 = "{$cache}repertoire.png";
      $imagerep2 = "{$cache}repertoire-temporaire.png";
      @rename($imagerep1,$imagerep2);
      // Paramètres pour photos-repertoires.php
      $rep_id = 1;
      $nouvrep = "Exemple de répertoire";
      $imagecache = "{$cache}temporaire1.png";
      // Génération de l'icône
      include('photos-repertoires.php');
      // Affichage
      header("Content-type: image/png");
      header("Content-Disposition: inline;");
      readfile($imagecache);
      // Destruction et renommage
      unlink($imagecache);
      @rename($imagerep2,$imagerep1);
    }
    // On demande un exemple d'icône de films
    elseif ( $_REQUEST['image'] == 2 )  {
      // Paramètres pour photos-films.php
      $taille = 2;
      $dim = $dimensions[1];
      $imagecache = "{$cache}temporaire2.png";
      // Génération de l'icône
      include('photos-films.php');
      // Affichage
      header("Content-type: image/png");
      header("Content-Disposition: inline;");
      readfile($imagecache);
      // Destruction
      unlink($imagecache);
    }
  }
  else  include('photos-admin.php');
  exit;
}

///////////////////////////////
// Affichage html 
if ( $img_id )  include('photos-html-img.php');
else  include('photos-html-rep.php');

?>