<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par le script principal photos-script.php
if ( !defined('OK') )  exit();

//////////////////////////////////////////////////////////////////////////////////
///////               Génération d'une image d'un répertoire               ///////
//////////////////////////////////////////////////////////////////////////////////

// L'icône du répertoire n'est pas dans le cache (ou l'id du répertoire ne correspond plus à son nom) : il faut la régénérer. 

// $rep_id, $nouvrep et $imagecache sont définies par le script appelant

// Vérification de la disponibilité de l'icône "générique" (sans texte dedans) repertoire.png dans le cache
$imagerep = "{$cache}repertoire.png";
$dim = $dimensions[1];
// Variables 
$grandrayon = $dim/10;
$ouverture = $dim/9;

if ( file_exists($imagerep) )
  $image = imagecreatefrompng($imagerep);
else  {
  // Si elle n'est pas dans le cache, on la génère
  $image = imagecreatetruecolor($dim,$dim);
  $noir = imagecolorallocate($image,0,0,0);
  eval("\$fond = imagecolorallocate(\$image,$couleur_rep_fond);");
  imagefilledrectangle($image,0,0,$dim-1,$dim-1,imagecolorallocate($image,255,255,255));

  // Variables 
  $diametre = 2*$grandrayon;
  $petitrayon = $grandrayon/2;
  $moitie = $dim/2;

  // Dessin des ombres
  $epaisseur = $dim/100;
  for ( $i = 5; $i > 0; $i-- ) {
    $hauteur = $i*$epaisseur;
    eval("\$ombre$i = imagecolorallocate(\$image," . str_replace(",","*$i/6,",$couleur_rep_fond) . "*$i/6);");
    imagefilledpolygon($image,array(
        $dim-1 , $dim-$petitrayon,
        $dim-$grandrayon+$hauteur , $diametre+$ouverture-$hauteur,
        $dim-$diametre+$hauteur , $diametre+$ouverture-$hauteur,
        $dim-$diametre+$hauteur , $grandrayon+$ouverture-$hauteur,
        $grandrayon , $grandrayon+$ouverture-$hauteur,
        $grandrayon , $dim-$petitrayon ),6,${"ombre" . $i});
    imagefilledarc($image,$dim-$diametre+$hauteur,$diametre+$ouverture-$hauteur,$diametre,$diametre,270,360,${"ombre" . $i},IMG_ARC_PIE);
  }
  
  // Dessin du devant du répertoire
  imageline($image,$dim-1,$dim-$petitrayon,$dim-$grandrayon,$diametre+$ouverture,$noir);
  imagearc($image,$dim-$diametre,$diametre+$ouverture,$diametre,$diametre,270,360,$noir);
  imageline($image,$dim-$diametre,$grandrayon+$ouverture,$grandrayon,$grandrayon+$ouverture,$noir);
  imagearc($image,$grandrayon,$diametre+$ouverture,$diametre,$diametre,180,270,$noir);
  imageline($image,0,$diametre+$ouverture,$grandrayon,$dim-$petitrayon,$noir);
  imagearc($image,$grandrayon+$petitrayon,$dim-$petitrayon,$grandrayon,$grandrayon,90,180,$noir);
  imageline($image,$grandrayon+$petitrayon,$dim-1,$dim-$petitrayon,$dim-1,$noir);
  imagearc($image,$dim-$petitrayon,$dim-$petitrayon,$grandrayon,$grandrayon,0,90,$noir);
  imagefilltoborder($image,$moitie,$moitie,$noir,$fond);

  // Dessin du dos du répertoire
  imageline($image,$dim-1,$dim-$petitrayon,$dim-1,$diametre,$noir);
  imagearc($image,$dim-$grandrayon,$diametre,$diametre,$diametre,270,360,$noir);
  imageline($image,$dim-$grandrayon,$grandrayon,$moitie+$grandrayon-1,$grandrayon,$noir);
  imagearc($image,$moitie+$grandrayon-1,$petitrayon,$grandrayon,$grandrayon,90,180,$noir);
  imagearc($image,$moitie,$petitrayon,$grandrayon,$grandrayon,270,360,$noir);
  imageline($image,$moitie,0,$diametre,0,$noir);
  imagearc($image,$diametre,$grandrayon,$diametre,$diametre,180,270,$noir);
  imageline($image,$grandrayon,$grandrayon,$grandrayon,$grandrayon+$ouverture,$noir);
  imagefill($image,$dim/4,$petitrayon,$fond);
  
  // Sauvegarde dans le cache
  imagepng($image,$imagerep);
}

// On a maintenant l'image sans texte, on va écrire le texte dessus

// Réglage des paramètres
$taille_police = $dim/12;
$taille = imagettfbbox($taille_police,0,$police,"abcde");
$nb_caracteres = $dim/(abs($taille[6]-$taille[2])/5);
eval("\$couleur_texte = imagecolorallocate(\$image,$couleur_rep_texte);");

// Si le répertoire est défini
if ( $rep_id )  {
  // Découpage du nom du répertoire s'il est trop grand pour une seule ligne
  $texte = explode("\n",wordwrap($nouvrep,$nb_caracteres,"\n",1));
  $n = count($texte);
}
// Si $rep_id vaut 0, on génère l'icône "Répertoire parent"
else  {
  $texte = array("Répertoire","parent");
  $n = -1; // Réglage artificiel en hauteur du texte dans l'icône
  $decalage = $grandrayon+2.5*$ouverture;
  imagefilledpolygon($image,array(
      $dim*13/20,$decalage,
      $dim*12/20,$decalage,
      $dim*12/20,$decalage+$dim/20,
      $dim*19/40,$decalage+$dim/20,
      $dim*10/20,$decalage+$dim/40,
      $dim*10/20,$decalage,
      $dim*6/20,$decalage+$dim*3/40,
      $dim*10/20,$decalage+$dim*3/20,
      $dim*10/20,$decalage+$dim*5/40,
      $dim*19/40,$decalage+$dim*2/20,
      $dim*13/20,$decalage+$dim*2/20
      ),11,$couleur_texte);
}

// Intégration du texte
foreach ( $texte as $l => $ligne )  {
  $ligne = trim($texte[$l]);
  $taille = imagettfbbox($taille_police,0,$police,$ligne);
  $taille = abs($taille[6]-$taille[2]);
  imagettftext($image,$taille_police,0,($dim-$taille)/2,($dim+$grandrayon+$ouverture)/2+1.5*$taille_police*($l-($n-1)/2),$couleur_texte,$police,$ligne);
}

// Enregistrement de l'icône dans le cache
imagepng($image,$imagecache);
imagedestroy($image);
?>