<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par le script principal photos-script.php
if ( !defined('OK') )  exit();

////////////////////////////////////////////////////////////////////////////////
////           Génération d'une miniature - photo redimensionnée            ////
////////////////////////////////////////////////////////////////////////////////

// Si la variable "taille" est définie, c'est que l'on veut une image seulement.
// 0 -> taille originale
// 1 -> taille "n°1" (la première dimension, en pixels ; la plus grande)
// 2 -> taille "n°2" (la seconde, en pixels ; la plus petite)
// $taille, $dim, $info, $img et $imagecache doivent être définies dans le script appelant.
// On doit se trouver dans le bon répertoire.

// Si la miniature n'est pas disponible, on la crée
$largeur = $info[0];
$hauteur = $info[1];

// La dimension verticale maximale n'est pas la même si $taille vaut 1 (pas d'affichage du nom) ou 2 (affichage du nom de l'image en bas)
switch ($taille) {
case 1:
  $dim_max = $dim*19/20;
  break;
case 2:
  $dim_max = $dim*17/20;
}

// La plus grande dimension détermine le redimensionnement
if ( $hauteur > $largeur )  {
  // Et on ne redimensionne pas pour agrandir
  $hauteurfinale = min($dim_max,$hauteur);
  $largeurfinale = $hauteurfinale*$largeur/$hauteur;
}
else  {
  $largeurfinale = min($dim*19/20,$largeur);
  $hauteurfinale = $largeurfinale*$hauteur/$largeur;
  if ( $hauteurfinale > $dim_max )  {
    $hauteurfinale = $dim_max;
    $largeurfinale = $hauteurfinale*$largeur/$hauteur;
  }
}
$imagefinale = imagecreatetruecolor($dim,$dim);
$noir = imagecolorallocate($imagefinale,0,0,0);
eval("\$fond = imagecolorallocate(\$imagefinale,$couleur_photos_fond);");
// On laisse un bord noir
imagefilledrectangle($imagefinale,1,1,$dim-2,$dim-2,$fond);

// Récupération de l'image
if ( stristr($info['mime'],"jpeg") )  $image = imagecreatefromjpeg($img);
else  $image = imagecreatefrompng($img);

// Redimensionnement et pour le petites miniatures affichage du texte
switch ($taille) {
case 1:
  imagecopyresampled($imagefinale,$image,($dim-$largeurfinale)/2,($dim-$hauteurfinale)/2,0,0,$largeurfinale,$hauteurfinale,$largeur,$hauteur);
  break;
case 2:
  imagecopyresampled($imagefinale,$image,($dim-$largeurfinale)/2,($dim*18/20-$hauteurfinale)/2,0,0,$largeurfinale,$hauteurfinale,$largeur,$hauteur);
  eval("\$texte = imagecolorallocate(\$imagefinale,$couleur_photos_texte);");
  $taille = imagettfbbox($dim/20,0,$police,$img);
  $taille = abs($taille[6]-$taille[2]);
  imagettftext($imagefinale,$dim/20,0,($dim-$taille)/2,$dim*19/20,$texte,$police,$img);
}

// Enregistrement et destruction de l'image en mémoire
imagejpeg($imagefinale,$imagecache,85);
imagedestroy($image);
imagedestroy($imagefinale);
?>